(() => {
  const TARGET_ABS_PREFIX = "https://app.famly.de/api/v2/images/tagged";

  const post = (p) => { try { window.postMessage(p, "*"); } catch {} };
  const dbg  = (kind, extra={}) => post({ __famlyDbg__: true, kind, ...extra });
  const push = (images) => post({ __famlyImages__: true, images });

  const extractFromJson = (json) => {
    if (!Array.isArray(json)) return [];
    const out = [];
    for (const img of json) {
      let bestUrl = null;
      if (img?.prefix && img?.key) bestUrl = `${img.prefix}/${img.key}`;
      else if (img?.url_big) bestUrl = img.url_big;
      else if (img?.big?.url) bestUrl = img.big.url;
      else if (img?.url) bestUrl = img.url;
      if (bestUrl) {
        out.push({
          url: bestUrl,
          key: img.key || bestUrl,
          imageId: img.imageId,
          createdAt: img.createdAt
        });
      }
    }
    return out;
  };

  const parseResponse = async (res) => {
    // Erst json(), dann text()→JSON, mit Debug
    try { return await res.clone().json(); }
    catch (e1) {
      try {
        const t = await res.clone().text();
        // kurze Probe fürs Debug
        dbg("fetch_text_sample", { len: t.length, head: t.slice(0, 120) });
        return JSON.parse(t);
      } catch (e2) {
        return null;
      }
    }
  };

  const _fetch = window.fetch;
  window.fetch = async function(input, init) {
    const res = await _fetch.apply(this, arguments);

    // Wir verlassen uns ausschließlich auf res.url (verlässlich gesetzt)
    const resUrl = (res && res.url) ? String(res.url) : "";
    const hit = resUrl.startsWith(TARGET_ABS_PREFIX);

    // Sichtbares Debug pro Request
    try {
      dbg("fetch_seen", {
        res: resUrl.slice(0, 200),
        status: res.status,
        type: res.type,                        // basic, cors, opaque
        ct: res.headers.get("content-type") || ""
      });
    } catch {}

    if (!hit) return res;

    try {
      const json = await parseResponse(res);
      if (json) {
        const found = extractFromJson(json);
        if (found.length) { push(found); dbg("fetch_hit", { count: found.length }); }
        else { dbg("fetch_no_urls"); }
      } else {
        dbg("fetch_parse_fail");
      }
    } catch (e) {
      dbg("fetch_hook_err", { e: String(e) });
    }
    return res;
  };

  // XHR-Fallback (meist nicht nötig, aber schadet nicht)
  const _open = XMLHttpRequest.prototype.open;
  const _send = XMLHttpRequest.prototype.send;
  XMLHttpRequest.prototype.open = function(method, url) {
    this.__famlyUrl = url;
    try { dbg("xhr_open", { url: String(url).slice(0, 200) }); } catch {}
    return _open.apply(this, arguments);
  };
  XMLHttpRequest.prototype.send = function(body) {
    if (!this.__famlyHandled && typeof this.addEventListener === "function") {
      this.__famlyHandled = true;
      this.addEventListener("load", function() {
        try {
          const abs = new URL(this.__famlyUrl || "", location.href).toString();
          if (abs.startsWith(TARGET_ABS_PREFIX) && (this.responseType === "" || this.responseType === "text")) {
            let json = null;
            try { json = JSON.parse(this.responseText); } catch {}
            if (json) {
              const found = extractFromJson(json);
              if (found.length) { push(found); dbg("xhr_hit", { count: found.length }); }
              else { dbg("xhr_no_urls"); }
            } else {
              dbg("xhr_parse_fail");
            }
          }
        } catch (e) { dbg("xhr_hook_err", { e: String(e) }); }
      });
    }
    return _send.apply(this, arguments);
  };

  dbg("hook_ready");
})();
