const countEl = document.getElementById("count");
const btn3 = document.getElementById("download3");
const btnAll = document.getElementById("downloadAll");
const btnCsv = document.getElementById("exportCsv");

function refreshCount(){
  chrome.runtime.sendMessage({ action: "getCount" }, (res) => {
    countEl.textContent = res?.count ?? 0;
    btn3.disabled = (res?.count ?? 0) === 0;
    btnAll.disabled = (res?.count ?? 0) === 0;
    btnCsv.disabled = (res?.count ?? 0) === 0;
  });
}

btn3.addEventListener("click", () => {
  btn3.disabled = true;
  chrome.runtime.sendMessage({ action: "downloadFirstN", n: 3 }, () => window.close());
});

btnAll.addEventListener("click", () => {
  btnAll.disabled = true;
  chrome.runtime.sendMessage({ action: "downloadAll" }, () => window.close());
});

btnCsv.addEventListener("click", () => {
  btnCsv.disabled = true;
  chrome.runtime.sendMessage({ action: "exportCSV" }, () => window.close());
});

document.addEventListener("DOMContentLoaded", refreshCount);
